"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SideSwitcher = void 0;
var __selfType = requireType("./SideSwitcherForLeaderboard");
function component(target) { target.getTypeName = function () { return __selfType; }; }
/**
 * Side Switcher
 * Version 0.0.5
 *
 * A UI element that is an alternative to the classic Toggle Button that allows users to pick from opposite/different states.
 * Unlike the classic Toggle, Side Switcher can have more than 2 options and is always attached to the edge of the screen,
 * allowing optimal use of the lens's free space without blocking the user's face.
 *
 * API:
 * switchToNext(): void - switches to the next state.
 * switchTo(icon: number): void - switches to the specified icon.
 * show(): void - animated shows side switcher.
 * hide(): void - animated hides side switcher.
 * disableIconBackground(): void - turns off the white icon's background.
 * enableIconBackground(): void - turns on the white icon's background.
 * enableInteractable(): void - allows interaction with the side switcher.
 * disableInteractable(): void - makes side switcher non-interactable.
 * (read-only) tooltip?: Tooltip - tooltip's script component if enabled.
 * (read-only) visible: boolean - whether the UI element is currently present.
 * activeIconIndex: number - index of the current active (selected) icon.
 * iconOpacity: number - an opacity of the icon.
 * backgroundOpacity: number - an opacity of the background.
 * icons: Texture[] - an array of switching icons.
 *
 * Events:
 *
 * onSwitch - triggers when switching (by touch and by API).
 * onManuallySwitch - triggers when switching by API.
 * onTouchStart - triggers when the touch starts.
 * onTouchMove - triggers when the touch moves.
 * onTouchEnd - triggers when the touch ends.
 * onEnabledInteractable - triggers when interactable enables.
 * onDisabledInteractable - triggers when interactable disables.
 * onShow - triggers when appearance animation starts.
 * onHide - triggers when disappearance animation starts.
 */
const Event_1 = require("./Modules/Event/Event");
const DestructionHelper_1 = require("./Modules/Scene/DestructionHelper");
const PropertyAnimator_1 = require("./Modules/Animation/PropertyAnimator");
const PassHelper_1 = require("./Modules/Scene/PassHelper");
const ComponentWithDebug_1 = require("./Modules/Debug/ComponentWithDebug");
const BehaviorEventCallbacks_1 = require("./Modules/BehaviorSupport/BehaviorEventCallbacks");
const OffsetConfig_1 = require("./Modules/Animation/Configs/OffsetConfig");
const ScaleConfig_1 = require("./Modules/Animation/Configs/ScaleConfig");
const SceneHelper_1 = require("./Modules/Scene/SceneHelper");
var Alignment;
(function (Alignment) {
    Alignment[Alignment["Left"] = -1] = "Left";
    Alignment[Alignment["Right"] = 1] = "Right";
})(Alignment || (Alignment = {}));
var ShowOption;
(function (ShowOption) {
    ShowOption[ShowOption["Auto"] = 0] = "Auto";
    ShowOption[ShowOption["Delay"] = 1] = "Delay";
    ShowOption[ShowOption["Custom"] = 2] = "Custom";
})(ShowOption || (ShowOption = {}));
let SideSwitcher = class SideSwitcher extends ComponentWithDebug_1.ComponentWithDebug {
    onAwake() {
        this.thisSO = this.getSceneObject();
        if (!this.validateCamera()) {
            return;
        }
        this.initialize();
    }
    /**
     * Returns whether the UI element is currently present.
     */
    get visible() {
        return this.isVisible;
    }
    /**
     * Getter for the tooltip's Script Component.
     */
    get tooltip() {
        return this._tooltip;
    }
    /**
     * Sets an icon's opacity.
     * @param value
     */
    set iconOpacity(value) {
        this._iconOpacity = value;
        this.setIconOpacity(value);
    }
    /**
     * Returns an icon's opacity.
     */
    get iconOpacity() {
        return this.iconImage.mainPass.baseColor.a;
    }
    /**
     * Sets a new background's opacity.
     * @param value
     */
    set backgroundOpacity(value) {
        if (this.interactable) {
            this._backgroundOpacity = value;
        }
        else {
            this.disabledBackgroundOpacity = value;
        }
        this.setBackgroundOpacity(value);
    }
    /**
     * Returns a background's opacity.
     */
    get backgroundOpacity() {
        return this.backgroundImage.mainPass.baseColor.a;
    }
    /**
     * Setter for an array of icons.
     * @param textures
     */
    set icons(textures) {
        this._icons = textures;
        this.updateIconTexture();
    }
    /**
     * Retrieves an array of the icons textures.
     */
    get icons() {
        return this._icons;
    }
    /**
     * Changes active(selected) icon without animation.
     * @param idx
     */
    set activeIconIndex(idx) {
        if (this.activeIcon == idx)
            return;
        this.activeIcon = idx;
        this.updateIconTexture();
        this.onManuallySwitch.trigger(this.activeIcon);
    }
    /**
     * Retrieves an index of the active(selected) icon.
     */
    get activeIconIndex() {
        return this.activeIcon;
    }
    /**
     * Switches to the next icon with animation.
     */
    switchToNext() {
        this.activeIcon = (this.activeIcon + 1) % this._icons.length;
        this.onManuallySwitch.trigger(this.activeIcon);
        this.switchAnimation();
    }
    /**
     * Switches to the specific icon with animation.
     * @param icon
     */
    switchTo(icon) {
        if (this.activeIcon == icon) {
            return;
        }
        if (icon >= this._icons.length) {
            this.printWarning('trying to switch to an invalid icon');
        }
        this.activeIcon = icon;
        this.onManuallySwitch.trigger(this.activeIcon);
        this.switchAnimation();
    }
    /**
     * Animated shows side switcher.
     */
    show() {
        if (this.isVisible) {
            return;
        }
        this.isVisible = true;
        this.showAnimation();
        this.onShow.trigger();
    }
    /**
     * Animated hides side switcher.
     */
    hide() {
        if (!this.isVisible) {
            return;
        }
        this.isVisible = false;
        this.hideAnimation();
        this.onHide.trigger();
    }
    /**
     * Disables the white icon's background.
     */
    disableIconBackground() {
        this.iconBackgroundImage.enabled = false;
    }
    /**
     * Enables the white icon's background.
     */
    enableIconBackground() {
        this.iconBackgroundImage.enabled = true;
    }
    /**
     * Enables interactable and updates background opacity to "on" state.
     */
    enableInteractable() {
        if (this.interactable) {
            return;
        }
        this.interactable = true;
        this.setBackgroundOpacity(this._backgroundOpacity);
        this.onEnabledInteractable.trigger();
    }
    /**
     * Disables interactable and updates background opacity to "off" state.
     */
    disableInteractable() {
        if (!this.interactable) {
            return;
        }
        this.interactable = false;
        this.setBackgroundOpacity(this.disabledBackgroundOpacity);
        this.onDisabledInteractable.trigger();
    }
    /**
     * Initializes all components of the side switcher.
     * @private
     */
    initialize() {
        this.initializeST();
        this.initializePrefab();
        this.initializeAlignment();
        this.initializeBackground();
        this.initializeIcon();
        this.initializeInteraction();
        this.initializeInteractable();
        this.initializeAnimations();
        this.showStartAnimation();
        this.initializeDestroyEv();
        this.initializeEventCallbacks();
        SceneHelper_1.SceneHelper.setRenderLayerRecursively(this.thisSO, this.thisSO.layer);
        SceneHelper_1.SceneHelper.setRenderOrderRecursively(this.thisSO, this.renderOrder);
        this.initializeTooltip();
    }
    get alignmentOffset() {
        if (this.unitType === Canvas.UnitType.World) {
            return this.alignment;
        }
        else {
            return this.alignment * this.POINTS_POSITION_OFFSET * 2;
        }
    }
    get positionOffset() {
        if (this.unitType === Canvas.UnitType.World) {
            return this.startWorldPositionOffset;
        }
        else {
            return this.alignment * -this.POINTS_POSITION_OFFSET;
        }
    }
    get scaledPositionOffset() {
        if (this.unitType === Canvas.UnitType.World) {
            return this.ANIMATED_POSITION_OFFSET * this.worldPositionRatio;
        }
        else {
            return this.alignment * this.POINTS_POSITION_OFFSET * this.POINTS_POSITION_RATION;
        }
    }
    validateCamera() {
        const camera = SceneHelper_1.SceneHelper.findComponentRecursively(this.thisSO, 'Camera');
        if (isNull(camera) || camera.type !== Camera.Type.Orthographic) {
            print('Warning! Place Side Switcher under the Orthographic Camera.');
            return false;
        }
        return true;
    }
    /**
     * Adds a ScreenTransform to the script's SceneObject if necessary.
     * @private
     */
    initializeST() {
        this.helper.getOrAddComponent(this.thisSO, 'ScreenTransform');
    }
    /**
     * Instantiates side switcher's prefab.
     * @private
     */
    initializePrefab() {
        const canvas = SceneHelper_1.SceneHelper.findComponentRecursively(this.thisSO, 'Canvas');
        if (!isNull(canvas) && canvas.unitType !== Canvas.UnitType.World) {
            this.unitType = Canvas.UnitType.Points;
            this.parentSO = this.helper.instantiatePrefab(this.prefabPoints, this.thisSO, 'SideSwitcherPrefab');
        }
        else {
            this.unitType = Canvas.UnitType.World;
            this.parentSO = this.helper.instantiatePrefab(this.prefabWorld, this.thisSO, 'SideSwitcherPrefab');
        }
    }
    /**
     * Set's selected alignment.
     * @private
     */
    initializeAlignment() {
        const alignmentName = this.alignment == Alignment.Left ? 'Left' : 'Right';
        this.parentSO.children.forEach((alignmentType) => {
            alignmentType.enabled = alignmentType.name.indexOf(alignmentName) >= 0;
            if (alignmentType.enabled) {
                this.backgroundSO = alignmentType;
            }
        });
        if (this.alignment == Alignment.Right) {
            this.startWorldPositionOffset = -0.5;
            this.worldPositionRatio = -0.5;
        }
    }
    /**
     * Initializes side switcher's background.
     * @private
     */
    initializeBackground() {
        this.backgroundST = this.helper.getOrAddComponent(this.backgroundSO, 'ScreenTransform');
        this.backgroundImage = this.helper.getOrAddComponent(this.backgroundSO, 'Image');
        PassHelper_1.PassHelper.cloneAndReplaceMaterial(this.backgroundImage);
    }
    /**
     * Initializes tooltip if selected.
     * @private
     */
    initializeTooltip() {
        if (this.tooltipEnabled) {
            this._tooltip = this.helper.createComponent(this.backgroundSO, this.tooltipComponent);
            this._tooltip.direction = (this.alignment === Alignment.Left) ? "Right" : "Left";
            this._tooltip.label = this.tooltipLabel;
            this._tooltip.autostart = false;
            switch (this.tooltipShowOption) {
                case ShowOption.Auto:
                    this._tooltip.show();
                    break;
                case ShowOption.Delay:
                    const tooltipDelay = this.createEvent('DelayedCallbackEvent');
                    tooltipDelay.bind(() => this._tooltip.show());
                    tooltipDelay.reset(this.tooltipDelay);
                    break;
            }
        }
    }
    /**
     * Initializes side switcher's icon.
     * @private
     */
    initializeIcon() {
        this.iconBackgroundSO = SceneHelper_1.SceneHelper.findChildObjectWithNameRecursively(this.backgroundSO, 'Icon Background');
        if (!this.iconBackgroundSO) {
            throw new Error('Side Switcher: Invalid Icon Background SceneObject.');
        }
        this.helper.getOrAddComponent(this.iconBackgroundSO, 'ScreenTransform');
        this.iconBackgroundImage = this.helper.getOrAddComponent(this.iconBackgroundSO, 'Image');
        PassHelper_1.PassHelper.cloneAndReplaceMaterial(this.iconBackgroundImage);
        this.iconSO = SceneHelper_1.SceneHelper.findChildObjectWithNameRecursively(this.iconBackgroundSO, 'Icon');
        if (!this.iconBackgroundSO) {
            throw new Error('Side Switcher: Invalid Icon SceneObject.');
        }
        this.helper.getOrAddComponent(this.iconSO, 'ScreenTransform');
        this.iconImage = this.helper.getOrAddComponent(this.iconSO, 'Image');
        PassHelper_1.PassHelper.cloneAndReplaceMaterial(this.iconImage);
        if (this.icons.length > 0) {
            this.updateIconTexture();
        }
    }
    /**
     * Initializes Interaction Component.
     * @private
     */
    initializeInteraction() {
        this.interactionC = this.helper.getOrAddComponent(this.backgroundSO, 'InteractionComponent');
        this.interactionC.onTouchStart.add(() => this.onInteractionTouchStart());
        this.interactionC.onTouchMove.add(() => this.onInteractionTouchMove());
        this.interactionC.onTouchEnd.add(() => this.onInteractionTouchEnd());
    }
    /**
     * Initializes interactable and initial state.
     * @private
     */
    initializeInteractable() {
        if (!this.interactable) {
            this.setBackgroundOpacity(this.disabledBackgroundOpacity);
        }
    }
    /**
     * Handles touch start. Switches the icon if interactable is on.
     * @private
     */
    onInteractionTouchStart() {
        if (!this.interactable) {
            return;
        }
        this.activeIcon = (this.activeIcon + 1) % this._icons.length;
        this.onTouchStart.trigger();
        this.switchAnimation();
        this.printDebug('Switched! Active Icon: ' + this.activeIcon);
    }
    onInteractionTouchMove() {
        if (!this.interactable) {
            return;
        }
        this.onTouchMove.trigger();
    }
    onInteractionTouchEnd() {
        if (!this.interactable) {
            return;
        }
        this.onTouchEnd.trigger();
    }
    /**
     * Shows the initial animation if selected.
     * @private
     */
    showStartAnimation() {
        if (!this.startAnimation) {
            return;
        }
        this.setIconOpacity(0.0);
        this.backgroundST.offsets.setCenter(new vec2(this.alignmentOffset, 0.0));
        this.showAnimation();
    }
    /**
     * Initializes animation for offset, scale and alpha.
     * @private
     */
    initializeAnimations() {
        this.offsetAnimation = new PropertyAnimator_1.PropertyAnimator({
            scriptComponent: this,
            defaultDuration: this.ANIMATION_DURATION_LONG
        });
        this.scaleAnimation = new PropertyAnimator_1.PropertyAnimator({
            scriptComponent: this,
            defaultDuration: this.ANIMATION_DURATION_LONG
        });
        this.alphaAnimation = new PropertyAnimator_1.PropertyAnimator({
            scriptComponent: this,
            defaultDuration: this.ANIMATION_DURATION_LONG
        });
        this.alphaAnimation.setupAnimation(() => this.getIconOpacity(), (value) => this.setIconOpacity(value), MathUtils.lerp);
        this.offsetAnimation.configure(new OffsetConfig_1.OffsetConfig(), this.backgroundST);
        this.scaleAnimation.configure(new ScaleConfig_1.ScaleConfig(), this.backgroundST);
    }
    /**
     * Initializes on destroy event.
     * @private
     */
    initializeDestroyEv() {
        this.createEvent('OnDestroyEvent').bind((e) => {
            this.alphaAnimation = null;
            this.scaleAnimation = null;
            this.offsetAnimation = null;
            this.helper.destroyObjects();
            this.removeEvent(e);
        });
    }
    initializeEventCallbacks() {
        if (this.eventCallbacks && this.callbackType !== BehaviorEventCallbacks_1.CallbackType.None) {
            this.onSwitch.add(BehaviorEventCallbacks_1.BehaviorEventCallbacks.invokeCallbackFromInputs(this, 'onSwitch'));
        }
    }
    /**
     * Animates icon's switching.
     * @private
     */
    switchAnimation() {
        this.onSwitch.trigger(this.activeIcon);
        this.alphaAnimation.startAnimation(0.0, this.ANIMATION_DURATION_MEDIUM);
        this.alphaAnimation.setCallbackOnFinish(() => {
            this.updateIconTexture();
            this.alphaAnimation.startAnimation(this._iconOpacity, this.ANIMATION_DURATION_MEDIUM);
            this.alphaAnimation.setCallbackOnFinish(null);
        });
    }
    /**
     * Shows an animation of the appearance.
     * @private
     */
    showAnimation() {
        this.offsetAnimation.startAnimation(new vec2(this.positionOffset, 0.0), this.ANIMATION_DURATION_MEDIUM);
        this.offsetAnimation.setCallbackOnFinish(() => {
            this.scaleAnimation.startAnimation(this.ANIMATED_TOOLTIP_SCALE, this.ANIMATION_DURATION_SHORT);
            this.offsetAnimation.startAnimation(new vec2(this.positionOffset + this.scaledPositionOffset, 0.0), this.ANIMATION_DURATION_SHORT);
            this.alphaAnimation.setCallbackOnFinish(null);
            this.offsetAnimation.setCallbackOnFinish(() => {
                this.scaleAnimation.startAnimation(this.DEFAULT_TOOLTIP_SCALE, this.ANIMATION_DURATION_SHORT);
                this.offsetAnimation.startAnimation(new vec2(this.positionOffset, 0.0), this.ANIMATION_DURATION_SHORT);
                this.offsetAnimation.setCallbackOnFinish(() => {
                    this.alphaAnimation.startAnimation(this._iconOpacity, this.ANIMATION_DURATION_LONG);
                    this.alphaAnimation.setCallbackOnFinish(null);
                });
            });
        });
    }
    /**
     * Shows an animation of the disappearance.
     * @private
     */
    hideAnimation() {
        this.offsetAnimation.startAnimation(new vec2(this.alignmentOffset, 0.0), this.ANIMATION_DURATION_MEDIUM);
        this.alphaAnimation.startAnimation(0.0, this.ANIMATION_DURATION_LONG);
        this.alphaAnimation.setCallbackOnFinish(null);
        this.offsetAnimation.setCallbackOnFinish(null);
        if (this.tooltipEnabled) {
            this._tooltip.hide();
        }
    }
    /**
     * Sets an opacity of icon and icon's background.
     * @param value
     * @private
     */
    setIconOpacity(value) {
        PassHelper_1.PassHelper.setBaseColorAlpha(this.iconBackgroundImage.mainPass, value);
        PassHelper_1.PassHelper.setBaseColorAlpha(this.iconImage.mainPass, value);
    }
    /**
     * Sets an opacity of side switcher's background.
     * @param value
     * @private
     */
    setBackgroundOpacity(value) {
        PassHelper_1.PassHelper.setBaseColorAlpha(this.backgroundImage.mainPass, value);
    }
    getIconOpacity() {
        return this.iconImage.mainPass.baseColor.a;
    }
    /**
     * Updates an icon's texture depending on index of the active icon.
     * @private
     */
    updateIconTexture() {
        if (!this._icons[this.activeIcon]) {
            this.printWarning('icon with ' + this.activeIcon + ' index is missing!');
            return;
        }
        this.iconImage.mainPass.baseTex = this._icons[this.activeIcon];
    }
    __initialize() {
        super.__initialize();
        this.onSwitch = new Event_1.Event();
        this.onManuallySwitch = new Event_1.Event();
        this.onTouchStart = new Event_1.Event();
        this.onTouchMove = new Event_1.Event();
        this.onTouchEnd = new Event_1.Event();
        this.onEnabledInteractable = new Event_1.Event();
        this.onDisabledInteractable = new Event_1.Event();
        this.onShow = new Event_1.Event();
        this.onHide = new Event_1.Event();
        this.ANIMATION_DURATION_SHORT = 0.05;
        this.ANIMATION_DURATION_MEDIUM = 0.1;
        this.ANIMATION_DURATION_LONG = 0.15;
        this.ANIMATED_TOOLTIP_SCALE = new vec3(1.3, 1.0, 1.0);
        this.DEFAULT_TOOLTIP_SCALE = vec3.one();
        this.ANIMATED_POSITION_OFFSET = 0.3;
        this.POINTS_POSITION_OFFSET = 53;
        this.POINTS_POSITION_RATION = -0.25;
        this.helper = new DestructionHelper_1.DestructionHelper();
        this.isVisible = true;
        this.activeIcon = 0;
        this._iconOpacity = 1.0;
        this._backgroundOpacity = 1.0;
        this.disabledBackgroundOpacity = 0.3;
        this.startWorldPositionOffset = 1.0;
        this.worldPositionRatio = 1.0;
    }
};
exports.SideSwitcher = SideSwitcher;
exports.SideSwitcher = SideSwitcher = __decorate([
    component
], SideSwitcher);
//# sourceMappingURL=SideSwitcherForLeaderboard.js.map